@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed Virtual Network reference type.
 * @property referenceName Reference ManagedVirtualNetwork name.
 * @property type Managed Virtual Network reference type.
 */
public data class ManagedVirtualNetworkReferenceResponse(
    public val referenceName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ManagedVirtualNetworkReferenceResponse): ManagedVirtualNetworkReferenceResponse = ManagedVirtualNetworkReferenceResponse(
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
