@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Source and target column mapping details.
 * @property attributeReference Reference of the source column used in the mapping. It is used for 'Direct' mapping type only.
 * @property attributeReferences List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
 * @property expression Expression used for 'Aggregate' and 'Derived' type mapping.
 * @property functionName Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type mapping.
 * @property name Name of the target column.
 * @property type Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
 */
public data class MapperAttributeMappingResponse(
    public val attributeReference: MapperAttributeReferenceResponse? = null,
    public val attributeReferences: List<MapperAttributeReferenceResponse>? = null,
    public val expression: String? = null,
    public val functionName: String? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperAttributeMappingResponse): MapperAttributeMappingResponse = MapperAttributeMappingResponse(
            attributeReference = javaType.attributeReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperAttributeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            attributeReferences = javaType.attributeReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperAttributeReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
            functionName = javaType.functionName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
