@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * CDC policy recurrence details.
 * @property frequency Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
 * @property interval Actual interval value as per chosen frequency.
 */
public data class MapperPolicyRecurrenceResponse(
    public val frequency: String? = null,
    public val interval: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperPolicyRecurrenceResponse): MapperPolicyRecurrenceResponse = MapperPolicyRecurrenceResponse(
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
