@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * CDC Policy.
 * @property mode Mode of running the CDC: batch vs continuous.
 * @property recurrence Defines the frequency and interval for running the CDC for batch mode.
 */
public data class MapperPolicyResponse(
    public val mode: String? = null,
    public val recurrence: MapperPolicyRecurrenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperPolicyResponse): MapperPolicyResponse = MapperPolicyResponse(
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            recurrence = javaType.recurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperPolicyRecurrenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
