@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Schema of a CDC table in terms of column names and their corresponding data types.
 * @property dataType Data type of the column.
 * @property name Name of the column.
 */
public data class MapperTableSchemaResponse(
    public val dataType: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperTableSchemaResponse): MapperTableSchemaResponse = MapperTableSchemaResponse(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
