@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List

/**
 * A object which contains list of tables and connection details for a target connection.
 * @property connection Source connection details.
 * @property dataMapperMappings List of table mappings.
 * @property relationships List of relationship info among the tables.
 * @property targetEntities List of source tables for a target connection.
 */
public data class MapperTargetConnectionsInfoResponse(
    public val connection: MapperConnectionResponse? = null,
    public val dataMapperMappings: List<DataMapperMappingResponse>? = null,
    public val relationships: List<Any>? = null,
    public val targetEntities: List<MapperTableResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperTargetConnectionsInfoResponse): MapperTargetConnectionsInfoResponse = MapperTargetConnectionsInfoResponse(
            connection = javaType.connection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperConnectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataMapperMappings = javaType.dataMapperMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DataMapperMappingResponse.Companion.toKotlin(args0)
                })
            }),
            relationships = javaType.relationships().map({ args0 -> args0 }),
            targetEntities = javaType.targetEntities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperTableResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
