@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Specify the name and value of custom metadata item.
 * @property name Metadata item key name. Type: string (or Expression with resultType string).
 * @property value Metadata item value. Type: string (or Expression with resultType string).
 */
public data class MetadataItemResponse(
    public val name: Any? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MetadataItemResponse): MetadataItemResponse = MetadataItemResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
