@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The MongoDB Atlas database dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property collection The collection name of the MongoDB Atlas database. Type: string (or Expression with resultType string).
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property parameters Parameters for dataset.
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'MongoDbAtlasCollection'.
 */
public data class MongoDbAtlasCollectionDatasetResponse(
    public val annotations: List<Any>? = null,
    public val collection: Any,
    public val description: String? = null,
    public val folder: DatasetResponseFolder? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val schema: Any? = null,
    public val structure: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MongoDbAtlasCollectionDatasetResponse): MongoDbAtlasCollectionDatasetResponse = MongoDbAtlasCollectionDatasetResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            collection = javaType.collection(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            structure = javaType.structure().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
