@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity MongoDB Atlas sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'MongoDbAtlasSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default value is "insert". Type: string (or Expression with resultType string). Type: string (or Expression with resultType string).
 */
public data class MongoDbAtlasSinkResponse(
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val sinkRetryCount: Any? = null,
    public val sinkRetryWait: Any? = null,
    public val type: String,
    public val writeBatchSize: Any? = null,
    public val writeBatchTimeout: Any? = null,
    public val writeBehavior: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MongoDbAtlasSinkResponse): MongoDbAtlasSinkResponse = MongoDbAtlasSinkResponse(
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            sinkRetryCount = javaType.sinkRetryCount().map({ args0 -> args0 }).orElse(null),
            sinkRetryWait = javaType.sinkRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            writeBatchSize = javaType.writeBatchSize().map({ args0 -> args0 }).orElse(null),
            writeBatchTimeout = javaType.writeBatchTimeout().map({ args0 -> args0 }).orElse(null),
            writeBehavior = javaType.writeBehavior().map({ args0 -> args0 }).orElse(null),
        )
    }
}
