@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Linked service for MongoDb data source.
 * @property allowSelfSignedServerCert Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authSource Database to verify the username and password. Type: string (or Expression with resultType string).
 * @property authenticationType The authentication type to be used to connect to the MongoDB database.
 * @property connectVia The integration runtime reference.
 * @property databaseName The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property enableSsl Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password Password for authentication.
 * @property port The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property server The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'MongoDb'.
 * @property username Username for authentication. Type: string (or Expression with resultType string).
 */
public data class MongoDbLinkedServiceResponse(
    public val allowSelfSignedServerCert: Any? = null,
    public val annotations: List<Any>? = null,
    public val authSource: Any? = null,
    public val authenticationType: String? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val databaseName: Any,
    public val description: String? = null,
    public val enableSsl: Any? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val port: Any? = null,
    public val server: Any,
    public val type: String,
    public val username: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MongoDbLinkedServiceResponse): MongoDbLinkedServiceResponse = MongoDbLinkedServiceResponse(
            allowSelfSignedServerCert = javaType.allowSelfSignedServerCert().map({ args0 ->
                args0
            }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authSource = javaType.authSource().map({ args0 -> args0 }).orElse(null),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databaseName = javaType.databaseName(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enableSsl = javaType.enableSsl().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            server = javaType.server(),
            type = javaType.type(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
