@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity source for a MongoDB database.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property batchSize Specifies the number of documents to return in each batch of the response from MongoDB instance. In most cases, modifying the batch size will not affect the user or the application. This property's main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer).
 * @property cursorMethods Cursor methods for Mongodb query
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property filter Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass an empty document ({}). Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'MongoDbV2Source'.
 */
public data class MongoDbV2SourceResponse(
    public val additionalColumns: Any? = null,
    public val batchSize: Any? = null,
    public val cursorMethods: MongoDbCursorMethodsPropertiesResponse? = null,
    public val disableMetricsCollection: Any? = null,
    public val filter: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val queryTimeout: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MongoDbV2SourceResponse): MongoDbV2SourceResponse = MongoDbV2SourceResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            cursorMethods = javaType.cursorMethods().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MongoDbCursorMethodsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            queryTimeout = javaType.queryTimeout().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
