@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Notebook parameter.
 * @property type Notebook parameter type.
 * @property value Notebook parameter value. Type: string (or Expression with resultType string).
 */
public data class NotebookParameterResponse(
    public val type: String? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.NotebookParameterResponse): NotebookParameterResponse = NotebookParameterResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
