@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The location of Oracle Cloud Storage dataset.
 * @property bucketName Specify the bucketName of Oracle Cloud Storage. Type: string (or Expression with resultType string)
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'OracleCloudStorageLocation'.
 * @property version Specify the version of Oracle Cloud Storage. Type: string (or Expression with resultType string).
 */
public data class OracleCloudStorageLocationResponse(
    public val bucketName: Any? = null,
    public val fileName: Any? = null,
    public val folderPath: Any? = null,
    public val type: String,
    public val version: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.OracleCloudStorageLocationResponse): OracleCloudStorageLocationResponse = OracleCloudStorageLocationResponse(
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
