@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Parquet read settings.
 * @property compressionProperties Compression settings.
 * @property type The read setting type.
 * Expected value is 'ParquetReadSettings'.
 */
public data class ParquetReadSettingsResponse(
    public val compressionProperties: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ParquetReadSettingsResponse): ParquetReadSettingsResponse = ParquetReadSettingsResponse(
            compressionProperties = javaType.compressionProperties().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
