@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Pipeline reference type.
 * @property name Reference name.
 * @property referenceName Reference pipeline name.
 * @property type Pipeline reference type.
 */
public data class PipelineReferenceResponse(
    public val name: String? = null,
    public val referenceName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.PipelineReferenceResponse): PipelineReferenceResponse = PipelineReferenceResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
