@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
 * @property name The name of the folder that this Pipeline is in.
 */
public data class PipelineResponseFolder(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.PipelineResponseFolder): PipelineResponseFolder = PipelineResponseFolder(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
