@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * PolyBase settings.
 * @property rejectSampleValue Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property rejectType Reject type.
 * @property rejectValue Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression with resultType number), minimum: 0.
 * @property useTypeDefault Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean (or Expression with resultType boolean).
 */
public data class PolybaseSettingsResponse(
    public val rejectSampleValue: Any? = null,
    public val rejectType: String? = null,
    public val rejectValue: Any? = null,
    public val useTypeDefault: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.PolybaseSettingsResponse): PolybaseSettingsResponse = PolybaseSettingsResponse(
            rejectSampleValue = javaType.rejectSampleValue().map({ args0 -> args0 }).orElse(null),
            rejectType = javaType.rejectType().map({ args0 -> args0 }).orElse(null),
            rejectValue = javaType.rejectValue().map({ args0 -> args0 }).orElse(null),
            useTypeDefault = javaType.useTypeDefault().map({ args0 -> args0 }).orElse(null),
        )
    }
}
