@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Linked service for PostgreSQLV2 data source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property commandTimeout The time to wait (in seconds) while trying to execute a command before terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
 * @property connectVia The integration runtime reference.
 * @property connectionTimeout The time to wait (in seconds) while trying to establish a connection before terminating the attempt and generating an error. Type: integer.
 * @property database Database name for connection. Type: string.
 * @property description Linked service description.
 * @property encoding Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string data. Type: string
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property logParameters When enabled, parameter values are logged when commands are executed. Type: boolean.
 * @property parameters Parameters for linked service.
 * @property password The Azure key vault secret reference of password in connection string. Type: string.
 * @property pooling Whether connection pooling should be used. Type: boolean.
 * @property port The port for the connection. Type: integer.
 * @property readBufferSize Determines the size of the internal buffer uses when reading. Increasing may improve performance if transferring large values from the database. Type: integer.
 * @property schema Sets the schema search path. Type: string.
 * @property server Server name for connection. Type: string.
 * @property sslCertificate Location of a client certificate to be sent to the server. Type: string.
 * @property sslKey Location of a client key for a client certificate to be sent to the server. Type: string.
 * @property sslMode SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4: verify-ca, 5: verify-full. Type: integer.
 * @property sslPassword Password for a key for a client certificate. Type: string.
 * @property timezone Gets or sets the session timezone. Type: string.
 * @property trustServerCertificate Whether to trust the server certificate without validating it. Type: boolean.
 * @property type Type of linked service.
 * Expected value is 'PostgreSqlV2'.
 * @property username Username for authentication. Type: string.
 */
public data class PostgreSqlV2LinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val commandTimeout: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionTimeout: Any? = null,
    public val database: Any,
    public val description: String? = null,
    public val encoding: Any? = null,
    public val encryptedCredential: String? = null,
    public val logParameters: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: AzureKeyVaultSecretReferenceResponse? = null,
    public val pooling: Any? = null,
    public val port: Any? = null,
    public val readBufferSize: Any? = null,
    public val schema: Any? = null,
    public val server: Any,
    public val sslCertificate: Any? = null,
    public val sslKey: Any? = null,
    public val sslMode: Any,
    public val sslPassword: Any? = null,
    public val timezone: Any? = null,
    public val trustServerCertificate: Any? = null,
    public val type: String,
    public val username: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.PostgreSqlV2LinkedServiceResponse): PostgreSqlV2LinkedServiceResponse = PostgreSqlV2LinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            commandTimeout = javaType.commandTimeout().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionTimeout = javaType.connectionTimeout().map({ args0 -> args0 }).orElse(null),
            database = javaType.database(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            logParameters = javaType.logParameters().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pooling = javaType.pooling().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            readBufferSize = javaType.readBufferSize().map({ args0 -> args0 }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            server = javaType.server(),
            sslCertificate = javaType.sslCertificate().map({ args0 -> args0 }).orElse(null),
            sslKey = javaType.sslKey().map({ args0 -> args0 }).orElse(null),
            sslMode = javaType.sslMode(),
            sslPassword = javaType.sslPassword().map({ args0 -> args0 }).orElse(null),
            timezone = javaType.timezone().map({ args0 -> args0 }).orElse(null),
            trustServerCertificate = javaType.trustServerCertificate().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            username = javaType.username(),
        )
    }
}
