@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The recurrence schedule.
 * @property hours The hours.
 * @property minutes The minutes.
 * @property monthDays The month days.
 * @property monthlyOccurrences The monthly occurrences.
 * @property weekDays The days of the week.
 */
public data class RecurrenceScheduleResponse(
    public val hours: List<Int>? = null,
    public val minutes: List<Int>? = null,
    public val monthDays: List<Int>? = null,
    public val monthlyOccurrences: List<RecurrenceScheduleOccurrenceResponse>? = null,
    public val weekDays: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RecurrenceScheduleResponse): RecurrenceScheduleResponse = RecurrenceScheduleResponse(
            hours = javaType.hours().map({ args0 -> args0 }),
            minutes = javaType.minutes().map({ args0 -> args0 }),
            monthDays = javaType.monthDays().map({ args0 -> args0 }),
            monthlyOccurrences = javaType.monthlyOccurrences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.RecurrenceScheduleOccurrenceResponse.Companion.toKotlin(args0)
                })
            }),
            weekDays = javaType.weekDays().map({ args0 -> args0 }),
        )
    }
}
