@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Redirect incompatible row settings
 * @property linkedServiceName Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string).
 * @property path The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
 */
public data class RedirectIncompatibleRowSettingsResponse(
    public val linkedServiceName: Any,
    public val path: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RedirectIncompatibleRowSettingsResponse): RedirectIncompatibleRowSettingsResponse = RedirectIncompatibleRowSettingsResponse(
            linkedServiceName = javaType.linkedServiceName(),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
