@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A remote private endpoint connection
 * @property privateEndpoint PrivateEndpoint of a remote private endpoint connection
 * @property privateLinkServiceConnectionState The state of a private link connection
 * @property provisioningState
 */
public data class RemotePrivateEndpointConnectionResponse(
    public val privateEndpoint: ArmIdWrapperResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkConnectionStateResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RemotePrivateEndpointConnectionResponse): RemotePrivateEndpointConnectionResponse = RemotePrivateEndpointConnectionResponse(
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ArmIdWrapperResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PrivateLinkConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
