@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Trigger that schedules pipeline reruns for all fixed time interval windows from a requested start time to requested end time.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property parentTrigger The parent trigger reference.
 * @property requestedEndTime The end time for the time period for which restatement is initiated. Only UTC time is currently supported.
 * @property requestedStartTime The start time for the time period for which restatement is initiated. Only UTC time is currently supported.
 * @property rerunConcurrency The max number of parallel time windows (ready for execution) for which a rerun is triggered.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property type Trigger type.
 * Expected value is 'RerunTumblingWindowTrigger'.
 */
public data class RerunTumblingWindowTriggerResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val parentTrigger: Any,
    public val requestedEndTime: String,
    public val requestedStartTime: String,
    public val rerunConcurrency: Int,
    public val runtimeState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RerunTumblingWindowTriggerResponse): RerunTumblingWindowTriggerResponse = RerunTumblingWindowTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            parentTrigger = javaType.parentTrigger(),
            requestedEndTime = javaType.requestedEndTime(),
            requestedStartTime = javaType.requestedStartTime(),
            rerunConcurrency = javaType.rerunConcurrency(),
            runtimeState = javaType.runtimeState(),
            type = javaType.type(),
        )
    }
}
