@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A Rest service dataset.
 * @property additionalHeaders The additional HTTP headers in the request to the RESTful API.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property paginationRules The pagination rules to compose next page requests.
 * @property parameters Parameters for dataset.
 * @property relativeUrl The relative URL to the resource that the RESTful API provides. Type: string (or Expression with resultType string).
 * @property requestBody The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
 * @property requestMethod The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'RestResource'.
 */
public data class RestResourceDatasetResponse(
    public val additionalHeaders: Map<String, Any>? = null,
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val folder: DatasetResponseFolder? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val paginationRules: Map<String, Any>? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val relativeUrl: Any? = null,
    public val requestBody: Any? = null,
    public val requestMethod: Any? = null,
    public val schema: Any? = null,
    public val structure: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RestResourceDatasetResponse): RestResourceDatasetResponse = RestResourceDatasetResponse(
            additionalHeaders = javaType.additionalHeaders().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            paginationRules = javaType.paginationRules().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            relativeUrl = javaType.relativeUrl().map({ args0 -> args0 }).orElse(null),
            requestBody = javaType.requestBody().map({ args0 -> args0 }).orElse(null),
            requestMethod = javaType.requestMethod().map({ args0 -> args0 }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            structure = javaType.structure().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
