@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.Suppress

/**
 * Execution policy for an activity.
 * @property count Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property intervalInSeconds Interval between retries in seconds. Default is 30.
 */
public data class RetryPolicyResponse(
    public val count: Any? = null,
    public val intervalInSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RetryPolicyResponse): RetryPolicyResponse = RetryPolicyResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            intervalInSeconds = javaType.intervalInSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
