@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress

/**
 * SSIS property override.
 * @property isSensitive Whether SSIS package property override value is sensitive data. Value will be encrypted in SSISDB if it is true
 * @property value SSIS package property override value. Type: string (or Expression with resultType string).
 */
public data class SSISPropertyOverrideResponse(
    public val isSensitive: Boolean? = null,
    public val `value`: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SSISPropertyOverrideResponse): SSISPropertyOverrideResponse = SSISPropertyOverrideResponse(
            isSensitive = javaType.isSensitive().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
