@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * SAP Business Warehouse Open Hub Destination Linked Service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clientId Client ID of the client on the BW system where the open hub destination is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property language Language of the BW system where the open hub destination is located. The default value is EN. Type: string (or Expression with resultType string).
 * @property logonGroup The Logon Group for the SAP System. Type: string (or Expression with resultType string).
 * @property messageServer The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
 * @property messageServerService The service name or port number of the Message Server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to access the SAP BW server where the open hub destination is located.
 * @property server Host name of the SAP BW instance where the open hub destination is located. Type: string (or Expression with resultType string).
 * @property systemId SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
 * @property systemNumber System number of the BW system where the open hub destination is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'SapOpenHub'.
 * @property userName Username to access the SAP BW server where the open hub destination is located. Type: string (or Expression with resultType string).
 */
public data class SapOpenHubLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val clientId: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val language: Any? = null,
    public val logonGroup: Any? = null,
    public val messageServer: Any? = null,
    public val messageServerService: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val server: Any? = null,
    public val systemId: Any? = null,
    public val systemNumber: Any? = null,
    public val type: String,
    public val userName: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SapOpenHubLinkedServiceResponse): SapOpenHubLinkedServiceResponse = SapOpenHubLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            logonGroup = javaType.logonGroup().map({ args0 -> args0 }).orElse(null),
            messageServer = javaType.messageServer().map({ args0 -> args0 }).orElse(null),
            messageServerService = javaType.messageServerService().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            systemId = javaType.systemId().map({ args0 -> args0 }).orElse(null),
            systemNumber = javaType.systemNumber().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
