@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity source for SAP Business Warehouse Open Hub Destination source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property baseRequestId The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will be retrieved. The default value is 0. Type: integer (or Expression with resultType integer ).
 * @property customRfcReadTableFunctionModule Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property excludeLastRequest Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sapDataColumnDelimiter The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'SapOpenHubSource'.
 */
public data class SapOpenHubSourceResponse(
    public val additionalColumns: Any? = null,
    public val baseRequestId: Any? = null,
    public val customRfcReadTableFunctionModule: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val excludeLastRequest: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val queryTimeout: Any? = null,
    public val sapDataColumnDelimiter: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SapOpenHubSourceResponse): SapOpenHubSourceResponse = SapOpenHubSourceResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            baseRequestId = javaType.baseRequestId().map({ args0 -> args0 }).orElse(null),
            customRfcReadTableFunctionModule = javaType.customRfcReadTableFunctionModule().map({ args0 ->
                args0
            }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            excludeLastRequest = javaType.excludeLastRequest().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            queryTimeout = javaType.queryTimeout().map({ args0 -> args0 }).orElse(null),
            sapDataColumnDelimiter = javaType.sapDataColumnDelimiter().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
