@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * SAP Table Linked Service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clientId Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property language Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType string).
 * @property logonGroup The Logon Group for the SAP System. Type: string (or Expression with resultType string).
 * @property messageServer The hostname of the SAP Message Server. Type: string (or Expression with resultType string).
 * @property messageServerService The service name or port number of the Message Server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to access the SAP server where the table is located.
 * @property server Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string).
 * @property sncLibraryPath External security product's library to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 * @property sncMode SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string).
 * @property sncMyName Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 * @property sncPartnerName Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 * @property sncQop SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string).
 * @property systemId SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string).
 * @property systemNumber System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'SapTable'.
 * @property userName Username to access the SAP server where the table is located. Type: string (or Expression with resultType string).
 */
public data class SapTableLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val clientId: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val language: Any? = null,
    public val logonGroup: Any? = null,
    public val messageServer: Any? = null,
    public val messageServerService: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val server: Any? = null,
    public val sncLibraryPath: Any? = null,
    public val sncMode: Any? = null,
    public val sncMyName: Any? = null,
    public val sncPartnerName: Any? = null,
    public val sncQop: Any? = null,
    public val systemId: Any? = null,
    public val systemNumber: Any? = null,
    public val type: String,
    public val userName: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SapTableLinkedServiceResponse): SapTableLinkedServiceResponse = SapTableLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            logonGroup = javaType.logonGroup().map({ args0 -> args0 }).orElse(null),
            messageServer = javaType.messageServer().map({ args0 -> args0 }).orElse(null),
            messageServerService = javaType.messageServerService().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            sncLibraryPath = javaType.sncLibraryPath().map({ args0 -> args0 }).orElse(null),
            sncMode = javaType.sncMode().map({ args0 -> args0 }).orElse(null),
            sncMyName = javaType.sncMyName().map({ args0 -> args0 }).orElse(null),
            sncPartnerName = javaType.sncPartnerName().map({ args0 -> args0 }).orElse(null),
            sncQop = javaType.sncQop().map({ args0 -> args0 }).orElse(null),
            systemId = javaType.systemId().map({ args0 -> args0 }).orElse(null),
            systemNumber = javaType.systemNumber().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
