@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * The settings that will be leveraged for SAP table source partitioning.
 * @property maxPartitionsNumber The maximum value of partitions the table will be split into. Type: integer (or Expression with resultType string).
 * @property partitionColumnName The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class SapTablePartitionSettingsResponse(
    public val maxPartitionsNumber: Any? = null,
    public val partitionColumnName: Any? = null,
    public val partitionLowerBound: Any? = null,
    public val partitionUpperBound: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SapTablePartitionSettingsResponse): SapTablePartitionSettingsResponse = SapTablePartitionSettingsResponse(
            maxPartitionsNumber = javaType.maxPartitionsNumber().map({ args0 -> args0 }).orElse(null),
            partitionColumnName = javaType.partitionColumnName().map({ args0 -> args0 }).orElse(null),
            partitionLowerBound = javaType.partitionLowerBound().map({ args0 -> args0 }).orElse(null),
            partitionUpperBound = javaType.partitionUpperBound().map({ args0 -> args0 }).orElse(null),
        )
    }
}
