@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Parameters of a script block.
 * @property direction The direction of the parameter.
 * @property name The name of the parameter. Type: string (or Expression with resultType string).
 * @property size The size of the output direction parameter.
 * @property type The type of the parameter.
 * @property value The value of the parameter. Type: string (or Expression with resultType string).
 */
public data class ScriptActivityParameterResponse(
    public val direction: String? = null,
    public val name: Any? = null,
    public val size: Int? = null,
    public val type: String? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ScriptActivityParameterResponse): ScriptActivityParameterResponse = ScriptActivityParameterResponse(
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
