@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List

/**
 * Script block of scripts.
 * @property parameters Array of script parameters. Type: array.
 * @property text The query text. Type: string (or Expression with resultType string).
 * @property type The type of the query. Please refer to the ScriptType for valid options. Type: string (or Expression with resultType string).
 */
public data class ScriptActivityScriptBlockResponse(
    public val parameters: List<ScriptActivityParameterResponse>? = null,
    public val text: Any,
    public val type: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ScriptActivityScriptBlockResponse): ScriptActivityScriptBlockResponse = ScriptActivityScriptBlockResponse(
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ScriptActivityParameterResponse.Companion.toKotlin(args0)
                })
            }),
            text = javaType.text(),
            type = javaType.type(),
        )
    }
}
