@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Log settings of script activity.
 * @property logDestination The destination of logs. Type: string.
 * @property logLocationSettings Log location settings customer needs to provide when enabling log.
 */
public data class ScriptActivityTypePropertiesResponseLogSettings(
    public val logDestination: String,
    public val logLocationSettings: LogLocationSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ScriptActivityTypePropertiesResponseLogSettings): ScriptActivityTypePropertiesResponseLogSettings =
            ScriptActivityTypePropertiesResponseLogSettings(
                logDestination = javaType.logDestination(),
                logLocationSettings = javaType.logLocationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.LogLocationSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
