@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Execution policy for an activity that supports secure input and output.
 * @property secureInput When set to true, Input from activity is considered as secure and will not be logged to monitoring.
 * @property secureOutput When set to true, Output from activity is considered as secure and will not be logged to monitoring.
 */
public data class SecureInputOutputPolicyResponse(
    public val secureInput: Boolean? = null,
    public val secureOutput: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SecureInputOutputPolicyResponse): SecureInputOutputPolicyResponse = SecureInputOutputPolicyResponse(
            secureInput = javaType.secureInput().map({ args0 -> args0 }).orElse(null),
            secureOutput = javaType.secureOutput().map({ args0 -> args0 }).orElse(null),
        )
    }
}
