@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Self referenced tumbling window trigger dependency.
 * @property offset Timespan applied to the start time of a tumbling window when evaluating dependency.
 * @property size The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
 * @property type The type of dependency reference.
 * Expected value is 'SelfDependencyTumblingWindowTriggerReference'.
 */
public data class SelfDependencyTumblingWindowTriggerReferenceResponse(
    public val offset: String,
    public val size: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SelfDependencyTumblingWindowTriggerReferenceResponse): SelfDependencyTumblingWindowTriggerReferenceResponse =
            SelfDependencyTumblingWindowTriggerReferenceResponse(
                offset = javaType.offset(),
                size = javaType.size().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
