@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties of Self-hosted integration runtime node.
 * @property capabilities The integration runtime capabilities dictionary
 * @property concurrentJobsLimit Maximum concurrent jobs on the integration runtime node.
 * @property expiryTime The time at which the integration runtime will expire in ISO8601 format.
 * @property hostServiceUri URI for the host machine of the integration runtime.
 * @property isActiveDispatcher Indicates whether this node is the active dispatcher for integration runtime requests.
 * @property lastConnectTime The most recent time at which the integration runtime was connected in ISO8601 format.
 * @property lastEndUpdateTime The last time for the integration runtime node update end.
 * @property lastStartTime The time the node last started up.
 * @property lastStartUpdateTime The last time for the integration runtime node update start.
 * @property lastStopTime The integration runtime node last stop time.
 * @property lastUpdateResult The result of the last integration runtime node update.
 * @property machineName Machine name of the integration runtime node.
 * @property maxConcurrentJobs The maximum concurrent jobs in this integration runtime.
 * @property nodeName Name of the integration runtime node.
 * @property registerTime The time at which the integration runtime node was registered in ISO8601 format.
 * @property status Status of the integration runtime node.
 * @property version Version of the integration runtime node.
 * @property versionStatus Status of the integration runtime node version.
 */
public data class SelfHostedIntegrationRuntimeNodeResponse(
    public val capabilities: Map<String, String>,
    public val concurrentJobsLimit: Int,
    public val expiryTime: String,
    public val hostServiceUri: String,
    public val isActiveDispatcher: Boolean,
    public val lastConnectTime: String,
    public val lastEndUpdateTime: String,
    public val lastStartTime: String,
    public val lastStartUpdateTime: String,
    public val lastStopTime: String,
    public val lastUpdateResult: String,
    public val machineName: String,
    public val maxConcurrentJobs: Int,
    public val nodeName: String,
    public val registerTime: String,
    public val status: String,
    public val version: String,
    public val versionStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SelfHostedIntegrationRuntimeNodeResponse): SelfHostedIntegrationRuntimeNodeResponse = SelfHostedIntegrationRuntimeNodeResponse(
            capabilities = javaType.capabilities().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            concurrentJobsLimit = javaType.concurrentJobsLimit(),
            expiryTime = javaType.expiryTime(),
            hostServiceUri = javaType.hostServiceUri(),
            isActiveDispatcher = javaType.isActiveDispatcher(),
            lastConnectTime = javaType.lastConnectTime(),
            lastEndUpdateTime = javaType.lastEndUpdateTime(),
            lastStartTime = javaType.lastStartTime(),
            lastStartUpdateTime = javaType.lastStartUpdateTime(),
            lastStopTime = javaType.lastStopTime(),
            lastUpdateResult = javaType.lastUpdateResult(),
            machineName = javaType.machineName(),
            maxConcurrentJobs = javaType.maxConcurrentJobs(),
            nodeName = javaType.nodeName(),
            registerTime = javaType.registerTime(),
            status = javaType.status(),
            version = javaType.version(),
            versionStatus = javaType.versionStatus(),
        )
    }
}
