@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Self-hosted integration runtime status.
 * @property autoUpdate Whether Self-hosted integration runtime auto update has been turned on.
 * @property autoUpdateETA The estimated time when the self-hosted integration runtime will be updated.
 * @property capabilities Object with additional information about integration runtime capabilities.
 * @property createTime The time at which the integration runtime was created, in ISO8601 format.
 * @property dataFactoryName The data factory name which the integration runtime belong to.
 * @property internalChannelEncryption It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration runtime nodes exist).
 * @property latestVersion The latest version on download center.
 * @property links The list of linked integration runtimes that are created to share with this integration runtime.
 * @property localTimeZoneOffset The local time zone offset in hours.
 * @property nodes The list of nodes for this integration runtime.
 * @property pushedVersion The version that the integration runtime is going to update to.
 * @property scheduledUpdateDate The date at which the integration runtime will be scheduled to update, in ISO8601 format.
 * @property selfContainedInteractiveAuthoringEnabled An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
 * @property serviceUrls The URLs for the services used in integration runtime backend service.
 * @property state The state of integration runtime.
 * @property taskQueueId The task queue id of the integration runtime.
 * @property type The type of integration runtime.
 * Expected value is 'SelfHosted'.
 * @property updateDelayOffset The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours
 * @property version Version of the integration runtime.
 * @property versionStatus Status of the integration runtime version.
 */
public data class SelfHostedIntegrationRuntimeStatusResponse(
    public val autoUpdate: String,
    public val autoUpdateETA: String,
    public val capabilities: Map<String, String>,
    public val createTime: String,
    public val dataFactoryName: String,
    public val internalChannelEncryption: String,
    public val latestVersion: String,
    public val links: List<LinkedIntegrationRuntimeResponse>? = null,
    public val localTimeZoneOffset: String,
    public val nodes: List<SelfHostedIntegrationRuntimeNodeResponse>? = null,
    public val pushedVersion: String,
    public val scheduledUpdateDate: String,
    public val selfContainedInteractiveAuthoringEnabled: Boolean,
    public val serviceUrls: List<String>,
    public val state: String,
    public val taskQueueId: String,
    public val type: String,
    public val updateDelayOffset: String,
    public val version: String,
    public val versionStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SelfHostedIntegrationRuntimeStatusResponse): SelfHostedIntegrationRuntimeStatusResponse = SelfHostedIntegrationRuntimeStatusResponse(
            autoUpdate = javaType.autoUpdate(),
            autoUpdateETA = javaType.autoUpdateETA(),
            capabilities = javaType.capabilities().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            createTime = javaType.createTime(),
            dataFactoryName = javaType.dataFactoryName(),
            internalChannelEncryption = javaType.internalChannelEncryption(),
            latestVersion = javaType.latestVersion(),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedIntegrationRuntimeResponse.Companion.toKotlin(args0)
                })
            }),
            localTimeZoneOffset = javaType.localTimeZoneOffset(),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SelfHostedIntegrationRuntimeNodeResponse.Companion.toKotlin(args0)
                })
            }),
            pushedVersion = javaType.pushedVersion(),
            scheduledUpdateDate = javaType.scheduledUpdateDate(),
            selfContainedInteractiveAuthoringEnabled = javaType.selfContainedInteractiveAuthoringEnabled(),
            serviceUrls = javaType.serviceUrls().map({ args0 -> args0 }),
            state = javaType.state(),
            taskQueueId = javaType.taskQueueId(),
            type = javaType.type(),
            updateDelayOffset = javaType.updateDelayOffset(),
            version = javaType.version(),
            versionStatus = javaType.versionStatus(),
        )
    }
}
