@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Skip error file.
 * @property dataInconsistency Skip if source/sink file changed by other concurrent write. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property fileMissing Skip if file is deleted by other client during copy. Default is true. Type: boolean (or Expression with resultType boolean).
 */
public data class SkipErrorFileResponse(
    public val dataInconsistency: Any? = null,
    public val fileMissing: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SkipErrorFileResponse): SkipErrorFileResponse = SkipErrorFileResponse(
            dataInconsistency = javaType.dataInconsistency().map({ args0 -> args0 }).orElse(null),
            fileMissing = javaType.fileMissing().map({ args0 -> args0 }).orElse(null),
        )
    }
}
