@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Spark configuration reference.
 * @property referenceName Reference spark configuration name. Type: string (or Expression with resultType string).
 * @property type Spark configuration reference type.
 */
public data class SparkConfigurationParametrizationReferenceResponse(
    public val referenceName: Any,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SparkConfigurationParametrizationReferenceResponse): SparkConfigurationParametrizationReferenceResponse =
            SparkConfigurationParametrizationReferenceResponse(
                referenceName = javaType.referenceName(),
                type = javaType.type(),
            )
    }
}
