@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity SQL Data Warehouse sink.
 * @property allowCopyCommand Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
 * @property allowPolyBase Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType boolean).
 * @property copyCommandSettings Specifies Copy Command related settings when allowCopyCommand is true.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property polyBaseSettings Specifies PolyBase-related settings when allowPolyBase is true.
 * @property preCopyScript SQL pre-copy script. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sqlWriterUseTableLock Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
 * @property tableOption The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
 * @property type Copy sink type.
 * Expected value is 'SqlDWSink'.
 * @property upsertSettings SQL DW upsert settings.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum (or Expression with resultType SqlDWWriteBehaviorEnum)
 */
public data class SqlDWSinkResponse(
    public val allowCopyCommand: Any? = null,
    public val allowPolyBase: Any? = null,
    public val copyCommandSettings: DWCopyCommandSettingsResponse? = null,
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val polyBaseSettings: PolybaseSettingsResponse? = null,
    public val preCopyScript: Any? = null,
    public val sinkRetryCount: Any? = null,
    public val sinkRetryWait: Any? = null,
    public val sqlWriterUseTableLock: Any? = null,
    public val tableOption: Any? = null,
    public val type: String,
    public val upsertSettings: SqlDWUpsertSettingsResponse? = null,
    public val writeBatchSize: Any? = null,
    public val writeBatchTimeout: Any? = null,
    public val writeBehavior: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SqlDWSinkResponse): SqlDWSinkResponse = SqlDWSinkResponse(
            allowCopyCommand = javaType.allowCopyCommand().map({ args0 -> args0 }).orElse(null),
            allowPolyBase = javaType.allowPolyBase().map({ args0 -> args0 }).orElse(null),
            copyCommandSettings = javaType.copyCommandSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DWCopyCommandSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            polyBaseSettings = javaType.polyBaseSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PolybaseSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            preCopyScript = javaType.preCopyScript().map({ args0 -> args0 }).orElse(null),
            sinkRetryCount = javaType.sinkRetryCount().map({ args0 -> args0 }).orElse(null),
            sinkRetryWait = javaType.sinkRetryWait().map({ args0 -> args0 }).orElse(null),
            sqlWriterUseTableLock = javaType.sqlWriterUseTableLock().map({ args0 -> args0 }).orElse(null),
            tableOption = javaType.tableOption().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            upsertSettings = javaType.upsertSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SqlDWUpsertSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            writeBatchSize = javaType.writeBatchSize().map({ args0 -> args0 }).orElse(null),
            writeBatchTimeout = javaType.writeBatchTimeout().map({ args0 -> args0 }).orElse(null),
            writeBehavior = javaType.writeBehavior().map({ args0 -> args0 }).orElse(null),
        )
    }
}
