@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * The settings that will be leveraged for Sql source partitioning.
 * @property partitionColumnName The name of the column in integer or datetime type that will be used for proceeding partitioning. If not specified, the primary key of the table is auto-detected and used as the partition column. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
 * @property partitionUpperBound The maximum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
 */
public data class SqlPartitionSettingsResponse(
    public val partitionColumnName: Any? = null,
    public val partitionLowerBound: Any? = null,
    public val partitionUpperBound: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SqlPartitionSettingsResponse): SqlPartitionSettingsResponse = SqlPartitionSettingsResponse(
            partitionColumnName = javaType.partitionColumnName().map({ args0 -> args0 }).orElse(null),
            partitionLowerBound = javaType.partitionLowerBound().map({ args0 -> args0 }).orElse(null),
            partitionUpperBound = javaType.partitionUpperBound().map({ args0 -> args0 }).orElse(null),
        )
    }
}
