@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity SQL server source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property isolationLevel Specifies the transaction locking behavior for the SQL source. Allowed values: ReadCommitted/ReadUncommitted/RepeatableRead/Serializable/Snapshot. The default value is ReadCommitted. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property partitionOption The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange". Type: string (or Expression with resultType string).
 * @property partitionSettings The settings that will be leveraged for Sql source partitioning.
 * @property produceAdditionalTypes Which additional types to produce.
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sqlReaderQuery SQL reader query. Type: string (or Expression with resultType string).
 * @property sqlReaderStoredProcedureName Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with resultType string).
 * @property storedProcedureParameters Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
 * @property type Copy source type.
 * Expected value is 'SqlServerSource'.
 */
public data class SqlServerSourceResponse(
    public val additionalColumns: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val isolationLevel: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val partitionOption: Any? = null,
    public val partitionSettings: SqlPartitionSettingsResponse? = null,
    public val produceAdditionalTypes: Any? = null,
    public val queryTimeout: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val sqlReaderQuery: Any? = null,
    public val sqlReaderStoredProcedureName: Any? = null,
    public val storedProcedureParameters: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SqlServerSourceResponse): SqlServerSourceResponse = SqlServerSourceResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            isolationLevel = javaType.isolationLevel().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            partitionOption = javaType.partitionOption().map({ args0 -> args0 }).orElse(null),
            partitionSettings = javaType.partitionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SqlPartitionSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            produceAdditionalTypes = javaType.produceAdditionalTypes().map({ args0 -> args0 }).orElse(null),
            queryTimeout = javaType.queryTimeout().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            sqlReaderQuery = javaType.sqlReaderQuery().map({ args0 -> args0 }).orElse(null),
            sqlReaderStoredProcedureName = javaType.sqlReaderStoredProcedureName().map({ args0 ->
                args0
            }).orElse(null),
            storedProcedureParameters = javaType.storedProcedureParameters().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
