@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Ssis folder.
 * @property description Metadata description.
 * @property id Metadata id.
 * @property name Metadata name.
 * @property type The type of SSIS object metadata.
 * Expected value is 'Folder'.
 */
public data class SsisFolderResponse(
    public val description: String? = null,
    public val id: Double? = null,
    public val name: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SsisFolderResponse): SsisFolderResponse = SsisFolderResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
