@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Staging settings.
 * @property enableCompression Specifies whether to use compression when copying data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property linkedServiceName Staging linked service reference.
 * @property path The path to storage for storing the interim data. Type: string (or Expression with resultType string).
 */
public data class StagingSettingsResponse(
    public val enableCompression: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val path: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.StagingSettingsResponse): StagingSettingsResponse = StagingSettingsResponse(
            enableCompression = javaType.enableCompression().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
