@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * This activity evaluates an expression and executes activities under the cases property that correspond to the expression evaluation expected in the equals property.
 * @property cases List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
 * @property defaultActivities List of activities to execute if no case condition is satisfied. This is an optional property and if not provided, the activity will exit without any action.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property name Activity name.
 * @property on An expression that would evaluate to a string or integer. This is used to determine the block of activities in cases that will be executed.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'Switch'.
 * @property userProperties Activity user properties.
 */
public data class SwitchActivityResponse(
    public val cases: List<SwitchCaseResponse>? = null,
    public val defaultActivities: List<Any>? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val name: String,
    public val on: ExpressionResponse,
    public val onInactiveMarkAs: String? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SwitchActivityResponse): SwitchActivityResponse = SwitchActivityResponse(
            cases = javaType.cases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SwitchCaseResponse.Companion.toKotlin(args0)
                })
            }),
            defaultActivities = javaType.defaultActivities().map({ args0 -> args0 }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            on = javaType.on().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.ExpressionResponse.Companion.toKotlin(args0)
            }),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
