@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Switch cases with have a value and corresponding activities.
 * @property activities List of activities to execute for satisfied case condition.
 * @property value Expected value that satisfies the expression result of the 'on' property.
 */
public data class SwitchCaseResponse(
    public val activities: List<Any>? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SwitchCaseResponse): SwitchCaseResponse = SwitchCaseResponse(
            activities = javaType.activities().map({ args0 -> args0 }),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
