@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The Tar compression read settings.
 * @property preserveCompressionFileNameAsFolder Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean).
 * @property type The Compression setting type.
 * Expected value is 'TarReadSettings'.
 */
public data class TarReadSettingsResponse(
    public val preserveCompressionFileNameAsFolder: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TarReadSettingsResponse): TarReadSettingsResponse = TarReadSettingsResponse(
            preserveCompressionFileNameAsFolder = javaType.preserveCompressionFileNameAsFolder().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
