@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Trigger referenced dependency.
 * @property referenceTrigger Referenced trigger.
 * @property type The type of dependency reference.
 * Expected value is 'TriggerDependencyReference'.
 */
public data class TriggerDependencyReferenceResponse(
    public val referenceTrigger: TriggerReferenceResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TriggerDependencyReferenceResponse): TriggerDependencyReferenceResponse = TriggerDependencyReferenceResponse(
            referenceTrigger = javaType.referenceTrigger().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerReferenceResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
