@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Pipeline that needs to be triggered with the given parameters.
 * @property parameters Pipeline parameters.
 * @property pipelineReference Pipeline reference.
 */
public data class TriggerPipelineReferenceResponse(
    public val parameters: Map<String, Any>? = null,
    public val pipelineReference: PipelineReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TriggerPipelineReferenceResponse): TriggerPipelineReferenceResponse = TriggerPipelineReferenceResponse(
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            pipelineReference = javaType.pipelineReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PipelineReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
