@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Trigger reference type.
 * @property referenceName Reference trigger name.
 * @property type Trigger reference type.
 */
public data class TriggerReferenceResponse(
    public val referenceName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TriggerReferenceResponse): TriggerReferenceResponse = TriggerReferenceResponse(
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
