@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Trigger that schedules pipeline runs for all fixed time interval windows from a start time without gaps and also supports backfill scenarios (when start time is in the past).
 * @property annotations List of tags that can be used for describing the trigger.
 * @property delay Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property dependsOn Triggers that this trigger depends on. Only tumbling window triggers are supported.
 * @property description Trigger description.
 * @property endTime The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
 * @property frequency The frequency of the time windows.
 * @property interval The interval of the time windows. The minimum interval allowed is 15 Minutes.
 * @property maxConcurrency The max number of parallel time windows (ready for execution) for which a new run is triggered.
 * @property pipeline Pipeline for which runs are created when an event is fired for trigger window that is ready.
 * @property retryPolicy Retry policy that will be applied for failed pipeline runs.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property startTime The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
 * @property type Trigger type.
 * Expected value is 'TumblingWindowTrigger'.
 */
public data class TumblingWindowTriggerResponse(
    public val annotations: List<Any>? = null,
    public val delay: Any? = null,
    public val dependsOn: List<Any>? = null,
    public val description: String? = null,
    public val endTime: String? = null,
    public val frequency: String,
    public val interval: Int,
    public val maxConcurrency: Int,
    public val pipeline: TriggerPipelineReferenceResponse,
    public val retryPolicy: RetryPolicyResponse? = null,
    public val runtimeState: String,
    public val startTime: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TumblingWindowTriggerResponse): TumblingWindowTriggerResponse = TumblingWindowTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            delay = javaType.delay().map({ args0 -> args0 }).orElse(null),
            dependsOn = javaType.dependsOn().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            frequency = javaType.frequency(),
            interval = javaType.interval(),
            maxConcurrency = javaType.maxConcurrency(),
            pipeline = javaType.pipeline().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerPipelineReferenceResponse.Companion.toKotlin(args0)
            }),
            retryPolicy = javaType.retryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.RetryPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runtimeState = javaType.runtimeState(),
            startTime = javaType.startTime(),
            type = javaType.type(),
        )
    }
}
